/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.api;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.registry.Registries;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public abstract class ChiselingRecipeProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final String modid;
    private final DataGenerator generator;
    private final ExistingFileHelper existingFileHelper;
    private final Map<String, ChiselingRecipeBuilder> recipes = new HashMap<String, ChiselingRecipeBuilder>();

    public ChiselingRecipeProvider(String modid, DataGenerator generator, ExistingFileHelper existingFileHelper) {
        this.modid = modid;
        this.generator = generator;
        this.existingFileHelper = existingFileHelper;
    }

    public String m_6055_() {
        return "Chiseling Recipes: " + this.modid;
    }

    public void m_6865_(HashCache cache) {
        this.buildRecipes();
        Path path = this.generator.m_123916_();
        for (Map.Entry<String, ChiselingRecipeBuilder> entry : this.recipes.entrySet()) {
            String recipeName = entry.getKey();
            ChiselingRecipeBuilder builder = entry.getValue();
            if (builder.parent != null) {
                ResourceLocation parentLocation;
                ResourceLocation parent = builder.parent;
                while (parent != null && parent.m_135827_().equals(this.modid) && this.recipes.containsKey(parent.m_135815_())) {
                    parent = this.recipes.get((Object)parent.m_135815_()).parent;
                }
                if (parent != null && !this.existingFileHelper.exists(parentLocation = new ResourceLocation(parent.m_135827_(), "chiseling_recipes/" + (String)(parent.m_135815_().endsWith(".json") ? parent.m_135815_() : parent.m_135815_() + ".json")), PackType.SERVER_DATA)) {
                    throw new IllegalStateException("Could not find upward parent '" + parent + "' at '/data/" + parentLocation.m_135827_() + "/" + parentLocation.m_135815_() + "' for chiseling recipe: " + recipeName);
                }
            }
            JsonObject json = ChiselingRecipeProvider.serializeRecipe(recipeName, builder);
            Path recipePath = path.resolve("data/" + this.modid + "/chiseling_recipes/" + recipeName + ".json");
            ChiselingRecipeProvider.saveRecipe(cache, json, recipePath);
        }
    }

    private static JsonObject serializeRecipe(String recipeName, ChiselingRecipeBuilder recipe) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "rechiseled:chiseling");
        if (recipe.parent != null) {
            json.addProperty("parent", recipe.parent.toString());
        }
        HashSet items = Sets.newHashSet();
        JsonArray entries = new JsonArray();
        for (Triple<Item, Item, Boolean> entry : recipe.entries) {
            JsonObject object = new JsonObject();
            if (entry.getLeft() != null) {
                if (!items.add((Item)entry.getLeft())) {
                    throw new IllegalStateException("Duplicate item '" + Registries.ITEMS.getIdentifier((Object)((Item)entry.getLeft())) + "' in chiseling recipe '" + recipeName + "'");
                }
                object.addProperty("item", Registries.ITEMS.getIdentifier((Object)((Item)entry.getLeft())).toString());
            }
            if (entry.getMiddle() != null) {
                if (!items.add((Item)entry.getMiddle())) {
                    throw new IllegalStateException("Duplicate item '" + Registries.ITEMS.getIdentifier((Object)((Item)entry.getMiddle())) + "' in chiseling recipe '" + recipeName + "'");
                }
                object.addProperty("connecting_item", Registries.ITEMS.getIdentifier((Object)((Item)entry.getMiddle())).toString());
            }
            if (((Boolean)entry.getRight()).booleanValue()) {
                object.addProperty("optional", Boolean.valueOf(true));
            }
            entries.add((JsonElement)object);
        }
        json.add("entries", (JsonElement)entries);
        return json;
    }

    private static void saveRecipe(HashCache cache, JsonObject json, Path path) {
        try {
            String jsonString = GSON.toJson((JsonElement)json);
            String hash = f_123918_.hashUnencodedChars((CharSequence)jsonString).toString();
            if (!Objects.equals(cache.m_123938_(path), hash) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                    bufferedwriter.write(jsonString);
                }
            }
            cache.m_123940_(path, hash);
        }
        catch (IOException exception) {
            System.err.println("Couldn't save recipe '" + path + "'");
            exception.printStackTrace();
        }
    }

    private boolean validateRecipe(ResourceLocation recipe) {
        return this.existingFileHelper.exists(recipe, PackType.SERVER_DATA, ".json", "chiseling_recipes");
    }

    private void trackRecipe(String recipe) {
        this.existingFileHelper.trackGenerated(new ResourceLocation(this.modid, recipe), PackType.SERVER_DATA, ".json", "chiseling_recipes");
    }

    protected abstract void buildRecipes();

    protected ChiselingRecipeBuilder beginRecipe(String recipeName) {
        this.trackRecipe(recipeName);
        return this.recipes.computeIfAbsent(recipeName, s -> new ChiselingRecipeBuilder());
    }

    protected class ChiselingRecipeBuilder {
        private final List<Triple<Item, Item, Boolean>> entries = new LinkedList<Triple<Item, Item, Boolean>>();
        private ResourceLocation parent;

        private ChiselingRecipeBuilder() {
        }

        public ChiselingRecipeBuilder parent(ResourceLocation parent) {
            if (!ChiselingRecipeProvider.this.validateRecipe(parent)) {
                throw new IllegalArgumentException("Could not find parent recipe '" + parent + "'!");
            }
            this.parent = parent;
            return this;
        }

        public ChiselingRecipeBuilder add(@Nullable Item regularItem, @Nullable Item connectingItem, boolean optional) {
            if (regularItem == null && connectingItem == null) {
                throw new IllegalArgumentException("At least one of regular item or connecting item must not be null!");
            }
            this.entries.add((Triple<Item, Item, Boolean>)new ImmutableTriple((Object)regularItem, (Object)connectingItem, (Object)optional));
            return this;
        }

        public ChiselingRecipeBuilder add(Item regularItem, Item connectingItem) {
            return this.add(regularItem, connectingItem, false);
        }

        public ChiselingRecipeBuilder addRegularItem(Item item, boolean optional) {
            if (item == null) {
                throw new IllegalArgumentException("Item must not be null!");
            }
            return this.add(item, null, optional);
        }

        public ChiselingRecipeBuilder addRegularItem(Item item) {
            return this.addRegularItem(item, false);
        }

        public ChiselingRecipeBuilder addConnectingItem(Item item, boolean optional) {
            if (item == null) {
                throw new IllegalArgumentException("Item must not be null!");
            }
            return this.add(null, item, optional);
        }

        public ChiselingRecipeBuilder addConnectingItem(Item item) {
            return this.addConnectingItem(item, false);
        }
    }
}

